import uno
from scriptforge import CreateScriptService

def search_multi_column(*args):
    bas = CreateScriptService("Basic")

    # Prompt user for search term
    search_term = bas.InputBox("Enter search term:", "MultiColumn Search")
    if not search_term:
        bas.MsgBox("No search term entered.", "Search Result", "info")
        return
    search_term = search_term.strip().lower()

    # Prompt for columns
    col_input = bas.InputBox("Enter columns to search (e.g. C,E,ZZ,A-Z) or * for all non-empty columns:", "Column Selection")
    # Prompt for rows
    row_input = bas.InputBox("Enter rows to search (e.g. 1,3,5,1-100) or * for all non-empty rows:", "Row Selection")

    doc = XSCRIPTCONTEXT.getDocument()
    sheet = doc.getCurrentController().getActiveSheet()

    # Get used range
    cursor = sheet.createCursor()
    cursor.gotoEndOfUsedArea(False)
    last_row = cursor.getRangeAddress().EndRow
    last_col = cursor.getRangeAddress().EndColumn

    # Convert column letters to indices
    def col_letter_to_index(col):
        col = col.upper()
        index = 0
        for i, char in enumerate(reversed(col)):
            index += (ord(char) - ord('A') + 1) * (26 ** i)
        return index - 1

    # Expand column input
    def parse_columns(input_str):
        if input_str.strip() == "*":
            return list(range(last_col + 1))
        cols = set()
        for part in input_str.split(","):
            part = part.strip().upper()
            if "-" in part:
                start, end = part.split("-")
                start_idx = col_letter_to_index(start.strip())
                end_idx = col_letter_to_index(end.strip())
                cols.update(range(start_idx, end_idx + 1))
            elif part:
                cols.add(col_letter_to_index(part))
        return sorted(cols)

    # Expand row input
    def parse_rows(input_str):
        if input_str.strip() == "*":
            return list(range(last_row + 1))
        rows = set()
        for part in input_str.split(","):
            part = part.strip()
            if "-" in part:
                start, end = part.split("-")
                if start.isdigit() and end.isdigit():
                    rows.update(range(int(start) - 1, int(end)))
            elif part.isdigit():
                rows.add(int(part) - 1)
        return sorted(rows)

    col_indices = parse_columns(col_input)
    row_indices = parse_rows(row_input)

    # Search
    matches = []
    for row_index in row_indices:
        combined = ""
        for col_index in col_indices:
            try:
                cell = sheet.getCellByPosition(col_index, row_index)
                combined += str(cell.getString()).strip() + " "
            except:
                continue
        if search_term in combined.lower():
            matches.append(row_index + 1)

    # Show result
    if matches:
        msg = "Found in rows: " + ", ".join(map(str, matches))
    else:
        msg = "No matches found."

    bas.MsgBox(msg, "Search Result", "info")

g_exportedScripts = (search_multi_column,)